/*--------------------------------------
	icon.h
	The Cursor/Icon/Bundle Editor
	Mark Collins
	begun 5/31/93 12:35:36
	latest revision 8/3/93 15:44:00
*/

#pragma noroot
#pragma lint 3
#pragma memorymodel 0
#pragma optimize 14
/*  #pragma debug -1   */

#include <foundation.h>
#include <event.h>
#include <textedit.h>
#include <window.h>
#include <memory.h>
#include <quickdraw.h>
#include <qdaux.h>
#include <intmath.h>
#include <stdfile.h>
#include <stdio.h>

#define  FOR_SELECTOR		(1 << 10)
#define  MenuBarHeight		13	/* height of system menu bar */
#define  WTitleHeight		12	/* height of standard window title bar */
#define  ScrollBarHeight	13	/* height of standard scrollbar */
#define  ScrollBarWidth		13	/* width of standard scrollbar (use * hOffset)*/
#define  BucketTool		0	/* fill */
#define  PickerTool		1	/* pick color */
#define  PencilTool		2	/* bit paint */
#define  ShifterTool		3	/* shifter */
#define  ICNDISPWIN	0x1L		/* icon mode display window */
#define  UNDOITEM		0x00faL	/* undo */
#define  COPYITEM		0x00fcL	/* copy */
#define  PASTEITEM		0x00fdL	/* paste */
#define  CLEARITEM		0x00feL	/* clear */
#define  FLIPVERTITEM	0x0400L	/* flip vertical */
#define  FLIPHORZITEM	0x0401L	/* flip horizontal */
#define  COPYMASKITEM	0x0402L	/* copy icon to mask */
#define  MAKEMASKITEM	0x0403L	/* create mask menu item */
#define  FILLMASKITEM	0x0404L	/* fill that mask */
#define  FILLICONITEM	0x0405L	/* fill that icon */
#define  IMPORTITEM	0x0406L	/* import icon menu item */
#define  HOTSPOTITEM	0x0407L	/* set cursor hot spot */

struct timeData {					/* size = 8 bytes */
	char				timebytes[8];
	};
typedef struct timeData timeData, *timeDataPtr, **timeDataHndl;

struct OneDocData {				/* size = 110 bytes long */
	word				size;
	word				offsetToFlags;
	word				numResults;		/* must be 4 or 5 */
	word				result;
	long				rFinderPathID;
	long				internal1;		/* must be 0 */
	long				iconID;
	long				internal2;
	long				smIconID;
	long				internal3;
	handle			docStringHndl;
	long				matchFlags;
	word				fileType;			/* matchFileType */
	long				auxMask;			/* matchAuxType */
	long				auxType;			/* matchAuxType */
	handle			fileNameHndl;		/* matchFileName */
	word				CcompareSpec;		/* matchCreateDateTime */
	timeData			CtimeRec;			/* matchCreateDateTime */
	word				McompareSpec;		/* matchModDateTime */
	timeData			MtimeRec;			/* matchModDateTime */
	word				LAmask;			/* matchLocalAccess */
	word				LAvalue;			/* matchLocalAccess */
	long				NAmask;			/* matchNetworkAccess */
	long				NAvalue;			/* matchNetworkAccess */
	word				extMask;			/* matchExtended */
	word				compareValue;		/* matchExtended */
	long				HFSfileType;		/* matchHFSFileType */
	long				HFScreator;		/* matchHFSCreator */
	word				OptionListCount;	/* matchOptionList */
	handle			OptionListHndl;	/* matchOptionList */
	word				eofCompSpec;		/* match EOF */
	long				eof;				/* match EOF */
	};
typedef struct OneDocData OneDocData, *OneDocDataPtr, **OneDocDataHndl;

struct BundleStruct {					/* size = 18 + (oneDocCount * 4) bytes */
	word				version;
	word				offset;
	long				iconID;			/* rID for Application Icon */
	long				bundleID;			/* this bundle's resID */
	long				forFinder;		/* reserved, must be 0 */
	word				oneDocCount;		/* number of oneDocs in bundle */
	OneDocDataHndl		oneDocHndl[];		/* oneDoc Handle array */
};
typedef struct BundleStruct BundleStruct, *BundleStructPtr, **BundleStructHndl;

struct privateData {
	QDIconRecord		**editH;			/* the copy being edited */
	handle			resData;			/* the resource itself */
	QDIconRecord		**undoH;			/* copy of icon for undo */
	BundleStructHndl	structH;
	GrafPort			**imageCache;		/* offscreen image image */
	GrafPort			**maskCache;		/* offscreen mask image */
	word				flag;			/* bit 0 = dirty */
	Rect				fatIRect;			/* fatbits image rect */
	Rect				fatMRect;			/* fatbits mask rect */
	Rect				sizeRect;			/* resize box rect */
	word				color;			/* color selected */
	word				tool;			/* tool selected */
	long				resID;
	handle			winTitle;
	handle			winTempH;
	word				maskColor;		/* mask color selected */
	word				infoHeight;
	Rect				iconRect;			/* rect containing icon image */
	Rect				infoRect;			/* the infoBar rectangle */
	Rect				grafRect;			/* the window portRect */
	GrafPortPtr		winP;			/* the GrafPort */
	Point			hotSpot;
	word				resType;
	word				curGroup;
	word				curDoc;
	word				curAccess;
	handle			bunIcnCtlTemp;
	handle			bunSmIcnCtlTemp;
	handle			docIcnCtlTemp;
	handle			docSmIcnCtlTemp;
	handle			bunIcnCtl;
	handle			bunSmIcnCtl;
	handle			docIcnCtl;
	handle			docSmIcnCtl;
};
typedef struct privateData *privateDataPtr, **privateDataHndl;

#define PRIVATESIZE 142L

struct fileIconData {
	word				dataLength;		/* length of this data record */
	char				owner[64];		/* pathname of owner */
	char				name[16];			/* name of document or app */
	word				fileType;			/* filetype */
	word				auxType;			/* auxType */
	byte				largeIcon;
	};
typedef struct fileIconData fileIconData, *fileIconDataPtr, **fileIconDataHndl;

struct fileIconMember {
	QDIconRecord		*icnPtr;            /* pointer to the icon record */
	word				width;              /* icon width */
	word				height;             /* icon height */
	word				size;               /* size of icon record */
};
typedef struct fileIconMember fileIconMember;

struct fileIconArray {
	word				count;
	word				maxWidth;
	word				maxHeight;
	fileIconMember		icn[1];
};
typedef struct fileIconArray fileIconArray, *fileIconArrayPtr, **fileIconArrayHndl;

union uptr {
	Pointer			dataPtr;
	char				*bytePtr;
	word				*wordPtr;
	long				*longPtr;
	handle			*hndlPtr;
	OneDocData		*docPtr;
	BundleStructPtr	bundlePtr;
	timeDataPtr		timePtr;
	long				base;
};
typedef union uptr uptr;

union suPtr {
	char				*bPtr;
	word				*wPtr;
};
typedef union suPtr suPtr;

union morph {
	long				lng;
	word				wrd[2];
	char				cr[4];
};
typedef union morph morph;

/* Prototypes */
/* routines in imain.c */
word			REM_OPEN(fOpenRecPtr);
word			REM_CLOSE(fCloseRecPtr);
word			REM_WRITE(fCloseRecPtr);
word			REM_EVENT(fEventRecPtr);
word			REM_ACTIVATE(fActivateRecPtr);
word			REM_GETLINK(fLinkRecPtr);
word			REM_VIDMODE(fVidModeRecPtr);
word			REM_PRINT(fCloseRecPtr);
word			REM_STARTUP(fStartStopRecPtr);
word			REM_SHUTDOWN(fStartStopRecPtr);

/* routines in Common.c */
void			MakeGlobalRect(Rect *, Rect *);
word			getVid(void);
word			setMaxOf(word, word);
word			setMinOf(word, word);
void			stuffRect(Rect *, word, word, word, word);
void			FillLECtlWrd(word, GrafPortPtr, long);
void			FillLECtlLng(long, GrafPortPtr, long);
long			setMatchFlags(long, Handle, long);
void			setFlagCtl(long, Handle, long);
void			makeCursor (privateDataPtr);
void			extractCursor(privateDataPtr);
void			CreateOffPort(word, word, GrafPort ***);
void			AdjustOffPort(GrafPort **, word, word);
word			UpdateEditor(GrafPortPtr);
word			EditorMenu(EventRecord *);
void			DrawProc(void);
void			checkData(GrafPortPtr);
handle			loadIconRes(id);
privateDataHndl	getPrivate(GrafPortPtr);
word			verifyRes(word, long);
long			getIconID(long);
handle			loadEdResource(word, long);
long			sAddResource(word, long);
handle			loadRes(long, word);
void 			releaseRes(word, long);
handle			loadEdRes(long, word);
void			unloadEdRes(handle, word);
void			setTitle(word, long, GrafPortPtr);
void			sAddPrivateData(word, word, word, GrafPortPtr, long, handle, word);
word			sPalette1(word);
word			sPalette2(word, long);
handle			loadIconFileData(void);
void			changeHotSpot(privateDataPtr);

/* routines in iconstuff.c */
word			iconOpen(privateDataPtr, GrafPortPtr);
word 			iconEvent(fEventRecPtr);
void			SetWindowSize(privateDataPtr);
void			DrawInfoBarProc (GrafPortPtr, long, Rect *);
void			InitFatIcon(privateDataPtr);
word			InEditorInfo(EventRecord *);
word			CopyUndoIcon(privateDataPtr);
void			RedrawFatbits(privateDataPtr, word);
void			DisposeSource(GrafPortPtr);
void			copyRows(char *, char *, word, word, word);
void			Icon2Pixmap(QDIconRecord *, GrafPortPtr, word);
void			Pixmap2Icon(GrafPortPtr, QDIconRecord *, word);
word			GetPixelColor(word, word, QDIconRecord *, word);
word			PickColor(word, word, privateDataPtr, word);
void			Pt2Pixel(word, word, privateDataPtr, word, word *, word *);
void			FillIcon(privateDataPtr, Point, word);
word			FillSource(GrafPortPtr, QDIconRecord **);
void			MakeMask(privateDataPtr);
void			ShiftDraw2(word, word, GrafPortPtr);
void			ShiftIt(privateDataPtr, integer, integer);
void			ShiftIcon(privateDataPtr, Point);
void			UpdateColor(privateDataPtr);
void			GetPixelRect(word, word, Rect *);
void			DoBit(word, word, word, word, privateDataPtr);
word			ResizeIt(privateDataPtr, word, word);
void			GrowFat(privateDataPtr, Point);
void			FatClick(EventRecord *);
void			RedrawFat2(privateDataPtr);
void			RedrawFat(privateDataPtr);
word			GetColor(word, word, word, privateDataPtr, word);
void			ShiftDraw(word, word, word);
void			PaintImage(GrafPort **, word, word);
void			DrawEditor(void);
void			flopRect(Rect *, Rect *, Rect *);
void			GetPix(word, word, word *, word *, word, privateDataPtr);
void			PutPix(word, word, word, privateDataPtr);
void			drawCoords(privateDataPtr, word, word, word);
void			updateInfoIcon(privateDataPtr);
word			PickColor2(word, word, privateDataPtr, word);
word			PickOldColor2(word, word, privateDataPtr, word);
void			PutColor2(word, word, word, privateDataPtr, word);
void			flipIcon(privateDataPtr);
void			flipHorizIcon(privateDataPtr);
void			fillMask(privateDataPtr);
void			fillImage(privateDataPtr);
void			doClear(privateDataPtr);
void			copyIconToMask(privateDataPtr);
void			doUndo(privateDataPtr);
Handle			GetFileIcon(void);
Handle			GetIcon(fileIconArrayHndl);
void			doImport(privateDataPtr);
void			DrawFatImage2(privateDataPtr);
void			DrawFatMask2(privateDataPtr);

/* routines in bundstuff.c */
word			openBundle(privateDataPtr, GrafPortPtr);
void 			DrawBundle(void);
word 			bundleEvent(fEventRecPtr);
BundleStructHndl	ExtractBundleData(Handle);
OneDocDataHndl	ExtractOneDocData(Pointer);
Handle			RebuildOneDoc(OneDocDataPtr);
Handle			RebuildBundle(BundleStructHndl);

/* routines in bundctls.c */
void			SwapCtls (word, word, GrafPortPtr);
void			StoreCtls(word, GrafPortPtr, OneDocDataPtr);
void			FillCtls(word, GrafPortPtr, OneDocDataPtr);
void			setNetAccess(long *, long *, word);
void			putNetAccess(long, long, word);
void			HandleBundleCtls(privateDataPtr);
void			openBundleWindow(privateDataPtr);
void			storeBundleWindow(privateDataPtr);
handle			createIcnCtl (word, GrafPortPtr, IconButtonTemplate **, QDIconRecord *);
void			drawBundleIcons (privateDataPtr);
void 			printCount(privateDataPtr);

/* routines in Orca */
word                toolerror(void);
